<?php
require_once 'includes/database.php';

try {
    $db = new Database();
    $connection = $db->getConnection();
    
    // SQL to create tables
    $sql = "
    -- Customers table
    CREATE TABLE IF NOT EXISTS customers (
        id INT AUTO_INCREMENT PRIMARY KEY,
        customer_name VARCHAR(255) NOT NULL,
        email VARCHAR(255) NOT NULL,
        phone VARCHAR(50),
        company VARCHAR(255),
        address TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    );

    -- Product inquiries table
    CREATE TABLE IF NOT EXISTS product_inquiries (
        id INT AUTO_INCREMENT PRIMARY KEY,
        customer_id INT,
        product_name VARCHAR(255) NOT NULL,
        product_description TEXT,
        quantity INT,
        specifications TEXT,
        reference_photos VARCHAR(500),
        status ENUM('pending', 'processing', 'quoted', 'completed') DEFAULT 'pending',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (customer_id) REFERENCES customers(id)
    );

    -- Proforma Invoices table
    CREATE TABLE IF NOT EXISTS proforma_invoices (
        id INT AUTO_INCREMENT PRIMARY KEY,
        pi_number VARCHAR(100) UNIQUE NOT NULL,
        customer_id INT,
        inquiry_id INT,
        items JSON NOT NULL,
        subtotal DECIMAL(10,2),
        tax_amount DECIMAL(10,2),
        total_amount DECIMAL(10,2),
        currency VARCHAR(10) DEFAULT 'USD',
        validity_date DATE,
        terms_conditions TEXT,
        status ENUM('draft', 'sent', 'accepted', 'expired') DEFAULT 'draft',
        created_by INT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (customer_id) REFERENCES customers(id),
        FOREIGN KEY (inquiry_id) REFERENCES product_inquiries(id)
    );

    -- Sales orders table
    CREATE TABLE IF NOT EXISTS sales_orders (
        id INT AUTO_INCREMENT PRIMARY KEY,
        so_number VARCHAR(100) UNIQUE NOT NULL,
        pi_id INT,
        customer_id INT,
        order_date DATE,
        delivery_date DATE,
        total_amount DECIMAL(10,2),
        status ENUM('pending', 'confirmed', 'shipped', 'delivered', 'cancelled') DEFAULT 'pending',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (pi_id) REFERENCES proforma_invoices(id),
        FOREIGN KEY (customer_id) REFERENCES customers(id)
    );

    -- Users table for admin
    CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(100) UNIQUE NOT NULL,
        email VARCHAR(255) NOT NULL,
        password_hash VARCHAR(255) NOT NULL,
        full_name VARCHAR(255),
        role ENUM('admin', 'manager', 'sales') DEFAULT 'sales',
        is_active BOOLEAN DEFAULT TRUE,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    );
    ";
    
    // Execute SQL
    $connection->exec($sql);
    
    // Create default admin user
    $password_hash = password_hash('admin123', PASSWORD_DEFAULT);
    $admin_sql = "
        INSERT IGNORE INTO users (username, email, password_hash, full_name, role) 
        VALUES ('admin', 'admin@yourcompany.com', '$password_hash', 'Administrator', 'admin')
    ";
    $connection->exec($admin_sql);
    
    echo "Database setup completed successfully!<br>";
    echo "Default admin login:<br>";
    echo "Username: admin<br>";
    echo "Password: admin123<br>";
    echo "<br><strong>IMPORTANT:</strong> Delete this setup.php file after installation!";
    
} catch (PDOException $e) {
    die("Database setup failed: " . $e->getMessage());
}
?>