<?php
require_once 'includes/database.php';
require_once 'includes/functions.php';

$db = new Database();
$message = '';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $customer_name = clean_input($_POST['customer_name']);
    $email = clean_input($_POST['email']);
    $phone = clean_input($_POST['phone']);
    $company = clean_input($_POST['company']);
    $product_name = clean_input($_POST['product_name']);
    $product_description = clean_input($_POST['product_description']);
    $quantity = intval($_POST['quantity']);
    $specifications = clean_input($_POST['specifications']);
    
    // Handle file upload
    $photo_path = '';
    if (isset($_FILES['reference_photo']) && $_FILES['reference_photo']['error'] === 0) {
        $photo_path = handle_file_upload($_FILES['reference_photo']);
    }
    
    // Save customer
    $customer_id = save_customer($db, [
        'customer_name' => $customer_name,
        'email' => $email,
        'phone' => $phone,
        'company' => $company
    ]);
    
    // Save inquiry
    if ($customer_id) {
        $inquiry_id = save_inquiry($db, [
            'customer_id' => $customer_id,
            'product_name' => $product_name,
            'product_description' => $product_description,
            'quantity' => $quantity,
            'specifications' => $specifications,
            'reference_photos' => $photo_path
        ]);
        
        if ($inquiry_id) {
            $message = '<div class="alert success">Thank you! Your inquiry has been submitted successfully. We will contact you soon with a quotation.</div>';
        } else {
            $message = '<div class="alert error">Sorry, there was an error submitting your inquiry. Please try again.</div>';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Product Inquiry System</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <header>
            <h1>Product Inquiry & Quotation System</h1>
            <p>Submit your product requirements and receive a Proforma Invoice</p>
        </header>

        <?php echo $message; ?>

        <div class="form-container">
            <form action="" method="POST" enctype="multipart/form-data" class="inquiry-form">
                <h2>Customer Information</h2>
                
                <div class="form-group">
                    <label for="customer_name">Full Name *</label>
                    <input type="text" id="customer_name" name="customer_name" required>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label for="email">Email Address *</label>
                        <input type="email" id="email" name="email" required>
                    </div>
                    <div class="form-group">
                        <label for="phone">Phone Number</label>
                        <input type="tel" id="phone" name="phone">
                    </div>
                </div>

                <div class="form-group">
                    <label for="company">Company Name</label>
                    <input type="text" id="company" name="company">
                </div>

                <h2>Product Requirements</h2>

                <div class="form-group">
                    <label for="product_name">Product Name *</label>
                    <input type="text" id="product_name" name="product_name" required>
                </div>

                <div class="form-group">
                    <label for="product_description">Product Description *</label>
                    <textarea id="product_description" name="product_description" rows="4" required></textarea>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label for="quantity">Quantity *</label>
                        <input type="number" id="quantity" name="quantity" min="1" required>
                    </div>
                    <div class="form-group">
                        <label for="reference_photo">Reference Photo/Drawing</label>
                        <input type="file" id="reference_photo" name="reference_photo" accept="image/*,.pdf,.doc,.docx">
                    </div>
                </div>

                <div class="form-group">
                    <label for="specifications">Technical Specifications/Requirements</label>
                    <textarea id="specifications" name="specifications" rows="4" placeholder="Please provide detailed specifications, dimensions, materials, etc."></textarea>
                </div>

                <button type="submit" class="btn-primary">Submit Inquiry</button>
            </form>
        </div>

        <div class="features">
            <h3>Why Use Our System?</h3>
            <div class="feature-grid">
                <div class="feature">
                    <h4>Quick Quotation</h4>
                    <p>Get Proforma Invoices within 24 hours</p>
                </div>
                <div class="feature">
                    <h4>Price History</h4>
                    <p>Access your previous purchase prices</p>
                </div>
                <div class="feature">
                    <h4>Easy Reordering</h4>
                    <p>Quick reorder using previous PI references</p>
                </div>
            </div>
        </div>
    </div>

    <script src="assets/js/script.js"></script>
</body>
</html>