<?php
require_once '../includes/database.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

try {
    $db = new Database();
    
    $customer_name = clean_input($_POST['customer_name']);
    $email = clean_input($_POST['email']);
    $phone = clean_input($_POST['phone'] ?? '');
    $company = clean_input($_POST['company'] ?? '');
    $product_name = clean_input($_POST['product_name']);
    $product_description = clean_input($_POST['product_description']);
    $quantity = intval($_POST['quantity']);
    $specifications = clean_input($_POST['specifications'] ?? '');
    
    // Handle file upload
    $photo_path = '';
    if (isset($_FILES['reference_photo']) && $_FILES['reference_photo']['error'] === 0) {
        $photo_path = handle_file_upload($_FILES['reference_photo']);
    }
    
    // Save customer
    $customer_id = save_customer($db, [
        'customer_name' => $customer_name,
        'email' => $email,
        'phone' => $phone,
        'company' => $company
    ]);
    
    if (!$customer_id) {
        throw new Exception('Failed to save customer information');
    }
    
    // Save inquiry
    $inquiry_id = save_inquiry($db, [
        'customer_id' => $customer_id,
        'product_name' => $product_name,
        'product_description' => $product_description,
        'quantity' => $quantity,
        'specifications' => $specifications,
        'reference_photos' => $photo_path
    ]);
    
    if ($inquiry_id) {
        echo json_encode([
            'success' => true,
            'message' => 'Inquiry submitted successfully!',
            'inquiry_id' => $inquiry_id
        ]);
    } else {
        throw new Exception('Failed to save inquiry');
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>