<?php
require_once '../includes/database.php';
require_once '../includes/auth.php';

check_admin_auth();
header('Content-Type: application/json');

$customer_id = $_GET['customer_id'] ?? 0;

if (!$customer_id) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Customer ID required']);
    exit;
}

try {
    $db = new Database();
    
    $history = $db->query(
        "SELECT pi.*, i.product_name, i.quantity as inquiry_quantity,
                DATE(pi.created_at) as quote_date,
                DATE(pi.validity_date) as validity_date
         FROM proforma_invoices pi
         LEFT JOIN product_inquiries i ON pi.inquiry_id = i.id
         WHERE pi.customer_id = ?
         ORDER BY pi.created_at DESC",
        [$customer_id]
    )->fetchAll();
    
    echo json_encode([
        'success' => true,
        'data' => $history
    ]);
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>