<?php
require_once '../includes/database.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

check_admin_auth();
$db = new Database();

$action = $_GET['action'] ?? 'list';
$message = '';

// Handle PI creation/update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['create_pi'])) {
        $pi_data = [
            'customer_id' => $_POST['customer_id'],
            'inquiry_id' => $_POST['inquiry_id'],
            'items' => json_encode($_POST['items']),
            'subtotal' => $_POST['subtotal'],
            'tax_rate' => $_POST['tax_rate'],
            'tax_amount' => $_POST['tax_amount'],
            'total_amount' => $_POST['total_amount'],
            'currency' => $_POST['currency'],
            'validity_date' => $_POST['validity_date'],
            'terms_conditions' => $_POST['terms_conditions']
        ];
        
        $pi_id = create_proforma_invoice($db, $pi_data);
        if ($pi_id) {
            $message = '<div class="alert success">Proforma Invoice created successfully!</div>';
            // Update inquiry status
            $db->query("UPDATE product_inquiries SET status = 'quoted' WHERE id = ?", [$_POST['inquiry_id']]);
        }
    }
}

// Get data based on action
switch ($action) {
    case 'create':
        $inquiry_id = $_GET['inquiry_id'] ?? 0;
        $inquiry = get_inquiry_details($db, $inquiry_id);
        $customer = get_customer_details($db, $inquiry['customer_id']);
        break;
        
    case 'view':
        $pi_id = $_GET['pi_id'] ?? 0;
        $pi = get_pi_details($db, $pi_id);
        $customer = get_customer_details($db, $pi['customer_id']);
        $inquiry = get_inquiry_details($db, $pi['inquiry_id']);
        break;
        
    case 'list':
    default:
        $pis = get_all_pis($db);
        break;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PI Management - Customer Support System</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
</head>
<body>
    <div class="admin-container">
        <!-- Sidebar same as admin/index.php -->
        
        <div class="main-content">
            <header class="admin-header">
                <h1>Proforma Invoice Management</h1>
            </header>

            <?php echo $message; ?>

            <?php if ($action === 'create' && $inquiry): ?>
            <!-- PI Creation Form -->
            <div class="card">
                <h2>Create Proforma Invoice</h2>
                <form method="POST" class="pi-form">
                    <input type="hidden" name="customer_id" value="<?php echo $customer['id']; ?>">
                    <input type="hidden" name="inquiry_id" value="<?php echo $inquiry['id']; ?>">
                    
                    <div class="customer-info">
                        <h3>Customer: <?php echo $customer['customer_name']; ?></h3>
                        <p>Product: <?php echo $inquiry['product_name']; ?></p>
                        <p>Quantity: <?php echo $inquiry['quantity']; ?></p>
                    </div>

                    <div class="form-section">
                        <h3>Items & Pricing</h3>
                        <div id="items-container">
                            <div class="item-row">
                                <input type="text" name="items[0][description]" placeholder="Item description" required>
                                <input type="number" name="items[0][quantity]" placeholder="Qty" min="1" required>
                                <input type="number" name="items[0][unit_price]" placeholder="Unit Price" step="0.01" required>
                                <input type="number" name="items[0][amount]" placeholder="Amount" readonly>
                                <button type="button" class="btn-remove-item">Remove</button>
                            </div>
                        </div>
                        <button type="button" id="add-item" class="btn-secondary">Add Item</button>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Subtotal</label>
                            <input type="number" name="subtotal" id="subtotal" readonly>
                        </div>
                        <div class="form-group">
                            <label>Tax Rate (%)</label>
                            <input type="number" name="tax_rate" id="tax_rate" value="0" step="0.01">
                        </div>
                        <div class="form-group">
                            <label>Tax Amount</label>
                            <input type="number" name="tax_amount" id="tax_amount" readonly>
                        </div>
                        <div class="form-group">
                            <label>Total Amount</label>
                            <input type="number" name="total_amount" id="total_amount" readonly>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label>Currency</label>
                            <select name="currency">
                                <option value="USD">USD</option>
                                <option value="EUR">EUR</option>
                                <option value="GBP">GBP</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Validity Date</label>
                            <input type="date" name="validity_date" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label>Terms & Conditions</label>
                        <textarea name="terms_conditions" rows="4">Payment: 50% advance, 50% before shipment&#10;Delivery: 4-6 weeks&#10;Warranty: 1 year</textarea>
                    </div>

                    <button type="submit" name="create_pi" class="btn-primary">Create Proforma Invoice</button>
                </form>
            </div>

            <?php elseif ($action === 'view' && $pi): ?>
            <!-- PI View -->
            <div class="card">
                <div class="pi-header">
                    <h2>Proforma Invoice: <?php echo $pi['pi_number']; ?></h2>
                    <div class="pi-actions">
                        <button class="btn-primary" onclick="printPI()">Print PI</button>
                        <button class="btn-secondary" onclick="emailPI()">Email to Customer</button>
                    </div>
                </div>
                
                <div class="pi-details">
                    <!-- PI details display -->
                </div>
            </div>

            <?php else: ?>
            <!-- PI List -->
            <div class="card">
                <h2>All Proforma Invoices</h2>
                <div class="table-container">
                    <table class="data-table">
                        <thead>
                            <tr>
                                <th>PI Number</th>
                                <th>Customer</th>
                                <th>Product</th>
                                <th>Amount</th>
                                <th>Created</th>
                                <th>Validity</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($pis as $pi): ?>
                            <tr>
                                <td><?php echo $pi['pi_number']; ?></td>
                                <td><?php echo $pi['customer_name']; ?></td>
                                <td><?php echo $pi['product_name']; ?></td>
                                <td>$<?php echo number_format($pi['total_amount'], 2); ?></td>
                                <td><?php echo date('M d, Y', strtotime($pi['created_at'])); ?></td>
                                <td><?php echo date('M d, Y', strtotime($pi['validity_date'])); ?></td>
                                <td><span class="status-badge status-<?php echo $pi['status']; ?>"><?php echo ucfirst($pi['status']); ?></span></td>
                                <td>
                                    <a href="?action=view&pi_id=<?php echo $pi['id']; ?>" class="btn-sm">View</a>
                                    <a href="../api/generate_pi_pdf.php?pi_id=<?php echo $pi['id']; ?>" class="btn-sm">PDF</a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <script src="../assets/js/pi_management.js"></script>
</body>
</html>