<?php
require_once '../includes/database.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

// Check authentication
check_admin_auth();

$db = new Database();

// Get statistics
$stats = get_dashboard_stats($db);
$recent_inquiries = get_recent_inquiries($db, 5);
$pending_pis = get_pending_pis($db, 5);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard - Customer Support System</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
</head>
<body>
    <div class="admin-container">
        <!-- Sidebar -->
        <div class="sidebar">
            <div class="logo">
                <h2>Support System</h2>
            </div>
            <nav class="admin-nav">
                <ul>
                    <li class="active"><a href="index.php">Dashboard</a></li>
                    <li><a href="pi_management.php">PI Management</a></li>
                    <li><a href="customer_records.php">Customer Records</a></li>
                    <li><a href="../includes/logout.php">Logout</a></li>
                </ul>
            </nav>
        </div>

        <!-- Main Content -->
        <div class="main-content">
            <header class="admin-header">
                <h1>Admin Dashboard</h1>
                <div class="user-info">
                    Welcome, <?php echo $_SESSION['user_fullname']; ?>
                </div>
            </header>

            <!-- Statistics -->
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-icon">📋</div>
                    <div class="stat-info">
                        <h3><?php echo $stats['total_inquiries']; ?></h3>
                        <p>Total Inquiries</p>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-icon">⏳</div>
                    <div class="stat-info">
                        <h3><?php echo $stats['pending_inquiries']; ?></h3>
                        <p>Pending Inquiries</p>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-icon">🧾</div>
                    <div class="stat-info">
                        <h3><?php echo $stats['total_pis']; ?></h3>
                        <p>Proforma Invoices</p>
                    </div>
                </div>
                <div class="stat-card">
                    <div class="stat-icon">👥</div>
                    <div class="stat-info">
                        <h3><?php echo $stats['total_customers']; ?></h3>
                        <p>Total Customers</p>
                    </div>
                </div>
            </div>

            <!-- Recent Activity -->
            <div class="content-grid">
                <div class="card">
                    <h3>Recent Inquiries</h3>
                    <div class="table-container">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Customer</th>
                                    <th>Product</th>
                                    <th>Quantity</th>
                                    <th>Date</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($recent_inquiries as $inquiry): ?>
                                <tr>
                                    <td>INQ-<?php echo $inquiry['id']; ?></td>
                                    <td><?php echo $inquiry['customer_name']; ?></td>
                                    <td><?php echo $inquiry['product_name']; ?></td>
                                    <td><?php echo $inquiry['quantity']; ?></td>
                                    <td><?php echo date('M d, Y', strtotime($inquiry['created_at'])); ?></td>
                                    <td><span class="status-badge status-<?php echo $inquiry['status']; ?>"><?php echo ucfirst($inquiry['status']); ?></span></td>
                                    <td>
                                        <a href="pi_management.php?action=create&inquiry_id=<?php echo $inquiry['id']; ?>" class="btn-sm">Create PI</a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="card">
                    <h3>Pending PIs</h3>
                    <div class="table-container">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>PI Number</th>
                                    <th>Customer</th>
                                    <th>Amount</th>
                                    <th>Created</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($pending_pis as $pi): ?>
                                <tr>
                                    <td><?php echo $pi['pi_number']; ?></td>
                                    <td><?php echo $pi['customer_name']; ?></td>
                                    <td>$<?php echo number_format($pi['total_amount'], 2); ?></td>
                                    <td><?php echo date('M d, Y', strtotime($pi['created_at'])); ?></td>
                                    <td><span class="status-badge status-<?php echo $pi['status']; ?>"><?php echo ucfirst($pi['status']); ?></span></td>
                                    <td>
                                        <a href="pi_management.php?action=view&pi_id=<?php echo $pi['id']; ?>" class="btn-sm">View</a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>