<?php
require_once '../includes/database.php';
require_once '../includes/auth.php';
require_once '../includes/functions.php';

check_admin_auth();
$db = new Database();

$search = $_GET['search'] ?? '';
$customer_id = $_GET['customer_id'] ?? 0;

// Get customers
$customers = $db->query(
    "SELECT * FROM customers 
     WHERE customer_name LIKE ? OR email LIKE ? 
     ORDER BY customer_name",
    ["%$search%", "%$search%"]
)->fetchAll();

// Get customer details if selected
$customer_details = null;
$customer_history = [];
if ($customer_id) {
    $customer_details = $db->query(
        "SELECT * FROM customers WHERE id = ?",
        [$customer_id]
    )->fetch();
    
    if ($customer_details) {
        $customer_history = get_customer_history($db, $customer_id);
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customer Records - Customer Support System</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
</head>
<body>
    <div class="admin-container">
        <!-- Sidebar -->
        <div class="sidebar">
            <div class="logo">
                <h2>Support System</h2>
            </div>
            <nav class="admin-nav">
                <ul>
                    <li><a href="index.php">Dashboard</a></li>
                    <li><a href="pi_management.php">PI Management</a></li>
                    <li class="active"><a href="customer_records.php">Customer Records</a></li>
                    <li><a href="../includes/logout.php">Logout</a></li>
                </ul>
            </nav>
        </div>

        <!-- Main Content -->
        <div class="main-content">
            <header class="admin-header">
                <h1>Customer Records & History</h1>
                <div class="user-info">
                    Welcome, <?php echo $_SESSION['user_fullname']; ?>
                </div>
            </header>

            <div class="content-grid">
                <!-- Customer List -->
                <div class="card">
                    <h2>Customer Search</h2>
                    <form method="GET" class="search-form">
                        <input type="text" name="search" value="<?php echo htmlspecialchars($search); ?>" 
                               placeholder="Search by name or email...">
                        <button type="submit" class="btn-primary">Search</button>
                    </form>

                    <div class="table-container">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Company</th>
                                    <th>Inquiries</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($customers as $customer): 
                                    $inquiry_count = $db->query(
                                        "SELECT COUNT(*) as count FROM product_inquiries WHERE customer_id = ?",
                                        [$customer['id']]
                                    )->fetch()['count'];
                                ?>
                                <tr class="<?php echo $customer_id == $customer['id'] ? 'selected' : ''; ?>">
                                    <td><?php echo htmlspecialchars($customer['customer_name']); ?></td>
                                    <td><?php echo htmlspecialchars($customer['email']); ?></td>
                                    <td><?php echo htmlspecialchars($customer['phone']); ?></td>
                                    <td><?php echo htmlspecialchars($customer['company']); ?></td>
                                    <td><?php echo $inquiry_count; ?></td>
                                    <td>
                                        <a href="?customer_id=<?php echo $customer['id']; ?>" class="btn-sm">View History</a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Customer History -->
                <?php if ($customer_details): ?>
                <div class="card">
                    <h2>Customer History: <?php echo htmlspecialchars($customer_details['customer_name']); ?></h2>
                    
                    <div class="customer-info">
                        <p><strong>Email:</strong> <?php echo htmlspecialchars($customer_details['email']); ?></p>
                        <p><strong>Phone:</strong> <?php echo htmlspecialchars($customer_details['phone']); ?></p>
                        <p><strong>Company:</strong> <?php echo htmlspecialchars($customer_details['company']); ?></p>
                    </div>

                    <h3>Purchase History</h3>
                    <div class="table-container">
                        <table class="data-table">
                            <thead>
                                <tr>
                                    <th>PI Number</th>
                                    <th>Product</th>
                                    <th>Quantity</th>
                                    <th>Amount</th>
                                    <th>Quote Date</th>
                                    <th>Validity</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($customer_history as $pi): 
                                    $items = json_decode($pi['items'], true);
                                    $first_item = $items[0] ?? [];
                                ?>
                                <tr>
                                    <td><?php echo $pi['pi_number']; ?></td>
                                    <td><?php echo htmlspecialchars($pi['product_name']); ?></td>
                                    <td><?php echo $pi['inquiry_quantity']; ?></td>
                                    <td>$<?php echo number_format($pi['total_amount'], 2); ?></td>
                                    <td><?php echo date('M d, Y', strtotime($pi['quote_date'])); ?></td>
                                    <td><?php echo date('M d, Y', strtotime($pi['validity_date'])); ?></td>
                                    <td><span class="status-badge status-<?php echo $pi['status']; ?>"><?php echo ucfirst($pi['status']); ?></span></td>
                                    <td>
                                        <a href="pi_management.php?action=view&pi_id=<?php echo $pi['id']; ?>" class="btn-sm">View PI</a>
                                        <button onclick="reusePI(<?php echo $pi['id']; ?>)" class="btn-sm">Reuse</button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script>
    function reusePI(piId) {
        if (confirm('Do you want to create a new PI based on this one?')) {
            window.location.href = 'pi_management.php?action=reuse&pi_id=' + piId;
        }
    }
    </script>
</body>
</html>